/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public interface Attribute {
    default public void adjustProperties(BlockBehaviour.Properties props) {
    }

    public static boolean has(BlockState state, Class<? extends Attribute> type) {
        return Attribute.has(state.m_60734_(), type);
    }

    public static boolean has(Block block, Class<? extends Attribute> type) {
        ITypeBlock typeBlock;
        return block instanceof ITypeBlock && (typeBlock = (ITypeBlock)block).getType().has(type);
    }

    public static <T extends Attribute> T get(BlockState state, Class<T> type) {
        return Attribute.get(state.m_60734_(), type);
    }

    public static <T extends Attribute> T get(IBlockProvider blockProvider, Class<T> type) {
        return Attribute.get(blockProvider.getBlock(), type);
    }

    public static <T extends Attribute> T get(Block block, Class<T> type) {
        T t;
        if (block instanceof ITypeBlock) {
            ITypeBlock typeBlock = (ITypeBlock)block;
            t = typeBlock.getType().get(type);
        } else {
            t = null;
        }
        return t;
    }

    public static boolean has(Block block1, Block block2, Class<? extends Attribute> type) {
        return Attribute.has(block1, type) && Attribute.has(block2, type);
    }

    public static Collection<Attribute> getAll(Block block) {
        Collection<Object> collection;
        if (block instanceof ITypeBlock) {
            ITypeBlock typeBlock = (ITypeBlock)block;
            collection = typeBlock.getType().getAll();
        } else {
            collection = Lists.newArrayList();
        }
        return collection;
    }

    public static <T extends Attribute> void ifHas(Block block, Class<T> type, Consumer<T> run) {
        ITypeBlock typeBlock;
        T attribute;
        if (block instanceof ITypeBlock && (attribute = (typeBlock = (ITypeBlock)block).getType().get(type)) != null) {
            run.accept(attribute);
        }
    }

    @Nullable
    public static Direction getFacing(BlockState state) {
        AttributeStateFacing attr = Attribute.get(state, AttributeStateFacing.class);
        return attr == null ? null : attr.getDirection(state);
    }

    @Nullable
    public static BlockState setFacing(BlockState state, Direction facing) {
        AttributeStateFacing attr = Attribute.get(state, AttributeStateFacing.class);
        return attr == null ? null : attr.setDirection(state, facing);
    }

    public static boolean isActive(BlockState state) {
        AttributeStateActive attr = Attribute.get(state, AttributeStateActive.class);
        return attr != null && attr.isActive(state);
    }

    @Nonnull
    public static BlockState setActive(BlockState state, boolean active) {
        AttributeStateActive attr = Attribute.get(state, AttributeStateActive.class);
        return attr == null ? state : attr.setActive(state, active);
    }

    @Nullable
    public static <TIER extends ITier> TIER getTier(IBlockProvider blockProvider, Class<TIER> tierClass) {
        return Attribute.getTier(blockProvider.getBlock(), tierClass);
    }

    @Nullable
    public static <TIER extends ITier> TIER getTier(Block block, Class<TIER> tierClass) {
        AttributeTier attr = Attribute.get(block, AttributeTier.class);
        return attr == null ? null : (TIER)attr.tier();
    }

    @Nullable
    public static BaseTier getBaseTier(Block block) {
        AttributeTier attr = Attribute.get(block, AttributeTier.class);
        return attr == null ? null : attr.tier().getBaseTier();
    }

    public static interface TileAttribute<TILE extends TileEntityMekanism>
    extends Attribute {
    }
}

